package rahmawati.paerah.jaluralternatif.data_jalur;


import android.app.ProgressDialog;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.ArrayAdapter;
import android.widget.FrameLayout;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import jp.wasabeef.recyclerview.animators.SlideInUpAnimator;
import rahmawati.paerah.jaluralternatif.AlertDialogManager;
import rahmawati.paerah.jaluralternatif.CONFIG_URL;
import rahmawati.paerah.jaluralternatif.ConnectionDetector;
import rahmawati.paerah.jaluralternatif.Detail;
import rahmawati.paerah.jaluralternatif.R;
import rahmawati.paerah.jaluralternatif.RecyclerItemClickListener;


/**
 * A simple {@link Fragment} subclass.
 */
public class List_nama_jalur extends Fragment {


    ListView list;
    ArrayAdapter<String> adapter;
    ConnectionDetector cd;
    Boolean isInternetPresent = false;
    AlertDialogManager alert = new AlertDialogManager();

    ProgressDialog pDialog;
    String status = "1";

    JSONArray college = null;
    ListView lve;
    String lati,longi;
    Adapter_jalur sadapter;
    RecyclerView recyclerView;
    public static final int CONNECTION_TIMEOUT = 10000;
    public static final int READ_TIMEOUT = 15000;

    public List_nama_jalur() {
        // Required empty public constructor
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        View view = inflater.inflate(R.layout.fragment_list_nama_jalur, container, false);
        Toast.makeText(getActivity(), "tab 2", Toast.LENGTH_SHORT).show();



        final FrameLayout frameLayout = (FrameLayout) view.findViewById(R.id.dummyfrag_bg);
        //frameLayout.setBackgroundColor();


        recyclerView = (RecyclerView) view.findViewById(R.id.list_jalur);
     //   LinearLayoutManager linearLayoutManager = new LinearLayoutManager(getActivity().getBaseContext());
       // recyclerView.setLayoutManager(linearLayoutManager);
        recyclerView.setItemAnimator(new SlideInUpAnimator(new OvershootInterpolator(1f)));
recyclerView.addOnItemTouchListener(new RecyclerItemClickListener(getContext(), recyclerView, new RecyclerItemClickListener.OnItemClickListener() {
    @Override
    public void onItemClick(View view, int position) {
        Data_jalur d = new Data_jalur();
        String nama = ((TextView) view.findViewById(R.id.nama))
                .getText().toString();
        String alamat = ((TextView) view.findViewById(R.id.alamat))
                .getText().toString();
        lati = ((TextView) view.findViewById(R.id.lati))
                .getText().toString();
        longi = ((TextView) view.findViewById(R.id.longi))
                .getText().toString();

        Intent x = new Intent(getActivity(), Detail.class);
        x.putExtra("nama", nama);
        x.putExtra("alamat", alamat);
        x.putExtra("lat", lati );
        x.putExtra("long", longi );
        startActivity(x);
    }

    @Override
    public void onLongItemClick(View view, int position) {

    }
}));
        recyclerView.setHasFixedSize(true);


        cekInternet();
        return view;
    }

    @Override
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);

      //  lve = (ListView)getActivity().findViewById(R.id.list);

     //   cekInternet();

    }




    private class Ambildata extends AsyncTask<String, String, String> {
        ProgressDialog pdLoading = new ProgressDialog(getContext());
        HttpURLConnection conn;
        URL url = null;

        @Override
        protected void onPreExecute() {
            super.onPreExecute();

            //this method will be running on UI thread
            pdLoading.setMessage("\tLoading...");
            pdLoading.setCancelable(false);
            pdLoading.show();

        }

        @Override
        protected String doInBackground(String... params) {
            try {

                // Enter URL address where your json file resides
                // Even you can make call to php file which returns json data
                CONFIG_URL cu = new CONFIG_URL();
                url = new URL(cu.getUrljalur());

            } catch (MalformedURLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                return e.toString();
            }
            try {

                // Setup HttpURLConnection class to send and receive data from php and mysql
                conn = (HttpURLConnection) url.openConnection();
                conn.setReadTimeout(READ_TIMEOUT);
                conn.setConnectTimeout(CONNECTION_TIMEOUT);
                conn.setRequestMethod("GET");

                // setDoOutput to true as we recieve data from json file
                conn.setDoOutput(true);

            } catch (IOException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
                return e1.toString();
            }

            try {

                int response_code = conn.getResponseCode();

                // Check if successful connection made
                if (response_code == HttpURLConnection.HTTP_OK) {

                    // Read data sent from server
                    InputStream input = conn.getInputStream();
                    BufferedReader reader = new BufferedReader(new InputStreamReader(input));
                    StringBuilder result = new StringBuilder();
                    String line;

                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }

                    // Pass data to onPostExecute method
                    return (result.toString());

                } else {

                    return ("unsuccessful");
                }

            } catch (IOException e) {
                e.printStackTrace();
                return e.toString();
            } finally {
                conn.disconnect();
            }


        }

        @Override
        protected void onPostExecute(String result) {
            Log.e("reza", "onPostExecute: " );
            //this method will be running on UI thread

            pdLoading.dismiss();
            List<Data_jalur> data=new ArrayList<>();

            pdLoading.dismiss();
            try {


                JSONObject object = new JSONObject(result);
                JSONArray jArray  = object.getJSONArray("jalur");


                // Extract data from json and store into ArrayList as class objects
                for(int i=0;i<jArray.length();i++){
                    JSONObject json_data = jArray.getJSONObject(i);
                    Data_jalur pData = new Data_jalur();

                    pData.id= json_data.getString("id");
                    pData.nama= json_data.getString("nama");
                    pData.jammacet= json_data.getString("jammacet");
                    pData.lat= json_data.getString("lati");
                    pData.longi= json_data.getString("longi");
                    data.add(pData);
                }

                // Setup and Handover data to recyclerview



                sadapter = new Adapter_jalur(getActivity(),data);
                recyclerView.setAdapter(sadapter);
                recyclerView.setLayoutManager(new LinearLayoutManager(getActivity()));





            } catch (JSONException e) {
                Toast.makeText(getContext(), e.toString(), Toast.LENGTH_LONG).show();
                Log.e("reza", e.toString() );
            }

        }

    }

    public void cekInternet() {
        cd = new ConnectionDetector(getActivity());
        isInternetPresent = cd.isConnectingToInternet();

        if (isInternetPresent) {

            new Ambildata().execute();

        } else {

            alert.showAlertDialog(getActivity(), "Peringatan",
                    "cek koneksi internet.",
                    false);
        }
    }
}
